/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <string>
#include <cstdlib>
#include "lexcast.hpp"

int main(int argc, char* argv[])
{
    try {
        if (argc > 1) {
            // przeksztaca pierwszy argument na typ int
            int value = lexical_cast<int>(argv[1]);

            // uywa typu int jako typu string
            std::string msg;
            msg = "Warto parametru: "
                  + lexical_cast<std::string>(value);
            std::cout << msg << std::endl;
        }
    }
    catch (const char* msg) {
        std::cerr << "Wyjtek: " << msg << std::endl;
        return EXIT_FAILURE;
    }
}

