/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagowkowy klas strumieni
#include <iostream>

// plik nagwkowy zawierajcy sta EXIT_FAILURE
#include <cstdlib>

int main()
{
    int x, y;

    // wywietla cuch zachty
    std::cout << "Dzielenie liczb cakowitych (x/y)\n\n";

    // wczytuje x
    std::cout << "x: ";
    if (! (std::cin >> x)) {
        /* bd podczas odczytu
         * => koczy dziaanie programu wywietlajc komunikat o bdzie
         *    i zwracajc status bdu
         */
        std::cerr << "Bd podczas odczytu wartoci"
                  << std::endl;
        return EXIT_FAILURE;
    }

    // wczytuje y
    std::cout << "y: ";
    if (! (std::cin >> y)) {
        /* error when reading
         * => exit program with error message and error status
         */
        /* bd podczas odczytu
         * => koczy dziaanie programu wywietlajc komunikat o bdzie
         *    i zwracajc status bdu
         */
        std::cerr << "Bd podczas odczytu wartoci"
                  << std::endl;
        return EXIT_FAILURE;
    }

    // bd jeli y rwne 0
    if (y == 0) {
        /* dzielenie przez zero
         * => koczy dziaanie programu wywietlajc komunikat o bdzie
         *    i zwracajc status bdu
         */
        std::cerr << "Bd: dzielenie przez 0" << std::endl;
        return EXIT_FAILURE;
    }

    // wywietla argumenty i wynik dzielenia
    std::cout << x << " podzielone przez " << y << " daje w wyniku "
              << x / y << std::endl;
}

