/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <strstream>

int main()
{
    // tworzy dynamiczny strumie C-acucha do zapisu
    std::ostrstream buffer;

    // zapisuje sformatowany acuch i docza znak koca acucha
    buffer << "Pi: " << 3.1415 << std::ends;

    /* wywietla acuch
     * - str() "zamraa" strumie C-acucha
     */
    std::cout << buffer.str() << std::endl;

    // przywraca moliwo manipulacji strumieniem
    buffer.freeze(false);

    // przyjmuje pozycj umoliwiajc nadpisanie std::ends
    buffer.seekp(-1,std::ios::end);

    // zapisuje kolejne dane w strumieniu acucha
    buffer << " lub take: " << std::scientific << 3.1415
           << std::ends;

    /* wywietla acuch
     * - str() "zamraa" strumie C-acucha
     */
    std::cout << buffer.str() << std::endl;

    // przywraca moliwo manipulacji strumieniem, aby destruktor mg zwolni pami 
    buffer.freeze(false);
}

