/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <string>       // acuchy
#include <iostream>     // wejcie i wyjcie
#include <fstream>      // pliki
#include <iomanip>      // setw()
#include <cstdlib>      // EXIT_FAILURE

// deklaracje wyprzedzajce
void writeCharsetInFile(const std::string& filename);
void printFile(const std::string& filename);

int main()
{
    try {
        writeCharsetInFile("charset.out");
        printFile ("charset.out");
    }
    catch (const std::string& msg) {
        std::cerr << "Wyjtek: " << msg << std::endl;
        return EXIT_FAILURE;
    }
}

void writeCharsetInFile(const std::string& filename)
{
    // otwiera plik do zapisu
    std::ofstream file(filename.c_str());

    // czy plik jest otwarty?
    if (! file) {
        // nie, wyrzuca wyjtek
        throw "nie mona otworzy pliku \"" + filename
              + "\" do zapisu";
    }

    // zapisuje znaki w pliku
    for (int i=32; i<127; ++i) {
        // jako kod i odpowiadajcy mu znak:
        file << "kod: " << std::setw(3) << i << "   "
             << "znak: " << static_cast<char>(i) << std::endl;
    }

}   // plik zostanie automatycznie zamknity

void printFile(const std::string& filename)
{
    // otwiera plik do odczytu
    std::ifstream file(filename.c_str());

    // czy plik jest otwarty?
    if (! file) {
        // nie, wyrzuca wyjtek
        throw "nie mona otworzy pliku \"" + filename
              + "\" do odczytu";
    }

    // kopiuje wszystkie znaki z pliku do std::cout
    char c;
    while (file.get(c)) {
        std::cout.put(c);
    }

}   // plik zostanie automatycznie zamknity

