/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// pliki nagwkowe
#include <iostream>
#include <fstream>
#include <string>

void printFileTwice(const std::string& filename)
{
    char c;

    // otwiera plik do odczytu
    std::ifstream file(filename.c_str());

    // wywietla zawarto pliku po raz pierwszy
    while (file.get(c)) {
        std::cout.put(c);
    }

    // kasuje znaczniki eofbit i failbit (ustawione na skutek napotkania EOF)
    file.clear();

    // ustawia pozycj odczytu pliku na pocztku pliku
    file.seekg(0);

    // wywietla zawarto pliku po raz drugi
    while (file.get(c)) {
        std::cout.put(c);
    }
}

int main(int argc, char* argv[])
{
    // wywietla dwukrotnie zawarto kadego z plikw przekazanych w wierszu polece
    for (int i=1; i<argc; ++i) {
        printFileTwice(argv[i]);
    }
}

