/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef RFRACTION_HPP
#define RFRACTION_HPP

// plik nagwkowy klasy bazowej
#include "frac.hpp"

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* klasa RFraction
 * - klasa pochodna klasy Fraction
 * - dostp do dziedziczonych skadowych pozostaje ograniczony 
 * - przygotowana do dalszego dziedziczenia
 */
class RFraction : public Fraction {
  protected:
    bool reducible;        // true: uamek mona skrci

    // funkcja pomocnicza: zwraca najwikszy wsplny podzielnik licznika i mianownika
    unsigned gcd() const;

  public:
    /* konstruktor domylny i konstruktor o jednym i dwch parametrach
     * - przekazuje parametry konstruktorowi klasy Fraction 
     */
    RFraction (int n = 0, int d = 1) : Fraction(n,d) {
        reducible = (gcd() > 1);
    }

    // przypisanie z mnoeniem (nowa implementacja)
    virtual const RFraction& operator*= (const Fraction&);

    // odczyt ze strumienia (nowa implementacja)
    virtual void scanFrom(std::istream&);

    // skracanie uamka
    virtual void reduce();

    // sprawdza, czy uamek moe by skrcony
    virtual bool isReducible() const {
        return reducible;
    }
};

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif    // RFRACTION_HPP

