/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// pliki nagwkowe zawierajce deklaracje funkcji min() and abs()
#include <algorithm>
#include <cstdlib>

// docza plik nagwkowy zawierajcy deklaracj klasy
#include "rfrac.hpp"

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* gcd()
 * - wyznacza najwikszy wsplny podzielnik licznika i mianownika
 */
unsigned RFraction::gcd() const
{
    if (numer == 0) {
        return denom;
    }

    /* ustala najwiksz liczb, przez ktra dziel si
     * bez reszty licznik i mianownik
     */
    unsigned divisor = std::min(std::abs(numer),denom);
    while (numer % divisor != 0  ||  denom % divisor != 0) {
        --divisor;
    }
    return divisor;
}

/* reduce()
 */
void RFraction::reduce()
{
    // jeli mona skrci uamek, to dzieli licznik i mianownik, przez wynik funkcji gcd()
    if (reducible) {
        int divisor = gcd();

        numer /= divisor;
        denom /= divisor;

        reducible = false;       // uamek zosta skrcony
    }
}

/* operator *=
 * - nowa implementacja
 */
const RFraction& RFraction::operator*= (const RFraction& f)
{
    // jak w klasie bazowej:
    numer *= f.numer;
    denom *= f.denom;

    // czy mona skrci?
    if (!reducible) {
        reducible = (gcd() > 1);
    }

    return  *this;
}

/* scanFrom()
 */
void RFraction::scanFrom(std::istream& strm)
{
    Fraction::scanFrom(strm);   // wywouje funkcj scanFrom() klasy bazowej

    reducible = (gcd() > 1);   // sprawdza, czy uamek mona skrci
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

