/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef LINE_HPP
#define LINE_HPP

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// plik nagwkowy zawierajcy deklaracj klasy bazowej
#include "geoobj.hpp"

namespace Geo {

/* klasa Line
 * - pochodna klasy GeoObj
 * - dane skadowe:
 *     - pocztek odcinka (pooenie odcinka, dziedziczona)
 *     - koniec odcinka (nowa)
 */
class Line : public GeoObj {
  protected:
    Coord p2;    // koniec odcinka

  public:
    // konstrutkor, ktrego parametrami s pocztek i koniec odcinka
    Line(const Coord& a, const Coord& b)
         : GeoObj(a), p2(b) {
    }

    // rysuje obiekt geometryczny (implementacja)
    virtual void draw() const;

    // przesuwa obiekt geometryczny (nowa implementacja)
    virtual void move(const Coord&);

    // destruktor wirtualny
    virtual ~Line() {
    }
};

/* rysowanie
 * - zdefiniowana jako funkcja rozwijana w miejscu wywoania
 */
inline void Line::draw() const
{
    std::cout << "Odcinek czcy punkt " << refpoint
              << " z punktem " << p2 << std::endl;
}

/* przesunicie
 * - nowa implementacja, funkcja rozwijana w miejscu wywoania
 */
inline void Line::move(const Coord& offset)
{
    refpoint += offset;    // reprezentuje GeoObj::move(offset);
    p2 += offset;
}

}  // przestrze nazw Geo

#endif // LINE_HPP

