/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// pliki nagwkowe uywanych klas
#include "line.hpp"
#include "circle.hpp"
#include "geogroup.hpp"

int main()
{
    Geo::Line l1(Geo::Coord(1,2), Geo::Coord(3,4));
    Geo::Line l2(Geo::Coord(7,7), Geo::Coord(0,0));
    Geo::Circle c(Geo::Coord(3,3), 11);

    Geo::GeoGroup g;

    g.add(l1);            // GeoGroup zawiera: - odcinek l1
    g.add(c);             //     - okrg c
    g.add(l2);            //     - odcinek l2

    g.draw();             // rysuje GeoGroup
    std::cout << std::endl;

    g.move(Geo::Coord(3,-3));  // przesuwa GeoGroup
    g.draw();                  // ponownie rysuje GeoGroup
    std::cout << std::endl;

    g.remove(l1);         // GeoGroup zawiera teraz tylko c i l2
    g.draw();             // ponownie rysuje GeoGroup
}

