/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// pliki nagwkowe uywanych klas
#include "line.hpp"
#include "circle.hpp"
#include "geoobj.hpp"

// deklaracja wyprzedzajca
void printGeoObj(const Geo::GeoObj&);

int main()
{
    Geo::Line l1(Geo::Coord(1,2), Geo::Coord(3,4));
    Geo::Line l2(Geo::Coord(7,7), Geo::Coord(0,0));
    Geo::Circle c(Geo::Coord(3,3), 11);

    // tablica rnych obiektw geometrycznych:
    Geo::GeoObj* coll[10];

    coll[0] = &l1;     // zawiera: - odcinek l1
    coll[1] = &c;      //     - okrg c
    coll[2] = &l2;     //     - odcinek l2

    /* przesuwa i rysuje obiekty geometryczne
     * - odpowiednia funkcja wywoywana jest automatycznie
     */
    for (int i=0; i<3; i++) {
        coll[i]->draw();
        coll[i]->move(Geo::Coord(3,-3));
    }

    // wywietla poszczeglne obiekty za pomoc funkcji pomocniczej
    printGeoObj(l1);
    printGeoObj(c);
    printGeoObj(l2);
}

void printGeoObj(const Geo::GeoObj& obj)
{
    /* odpowiednia funkcja wywoywana jest automatycznie
     */
    obj.draw();
}

