/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef GEOOBJ_HPP
#define GEOOBJ_HPP

// plik nagwkowy zawierajcy deklaracj klasy Coord
#include "coord.hpp"

namespace Geo {

/* abstrakcyjna klasa bazowa GeoObj
 * - klasa uoglnienia obiektw geometrycznych
 * - przygotowana do dziedziczenia
 */
class GeoObj {
  protected:
    // kady obiekt geometryczny posiada okrelone pooenie
    Coord refpoint;

    /* konstruktor, ktrego parametrem jest pocztkowe pooenie
     * - nie jest dostpny publicznie
     * - konstruktor domylny nie jest dostpny
     */
    GeoObj(const Coord& p) : refpoint(p) {
    }

  public:
    // przemieszcza obiekt geometryczny o podan warto przesunicia
    virtual void move(const Coord& offset) {
        refpoint += offset;
    }

    /* rysuje obiekt geometryczny
     * - pure virtual function
     */
    virtual void draw() const = 0;

    // destruktor wirtualny
    virtual ~GeoObj() {
    }
};

}  // przestrze nazw Geo

#endif  // GEOOBJ_HPP

