/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef GEOGROUP_HPP
#define GEOGROUP_HPP

// plik nagwkowy zawierajcy deklaracj klasy bazowej
#include "geoobj.hpp"

// plik nagwkowy zawierajcy deklaracj wektora
#include <vector>

namespace Geo {

/* klasa GeoGroup
 * - pochodna klasy GeoObj
 * - dane skadowe:
 *     - pooenie grupy (dziedziczona)
 *     - kolekecja elementw geometrycznych (nowa)
 */
class GeoGroup : public GeoObj {
  protected:
    std::vector<GeoObj*> elems;    // kolekcja wskanikw do obiektw GeoObjs

  public:
    // konstruktor o opcjonalnym parametrze reprezentujcym pooenie grupy
    GeoGroup(const Coord& p = Coord(0,0)) : GeoObj(p) {
    }

    // rysowanie (implementacja)
    virtual void draw() const;

    // wstawienie elementu
    virtual void add(GeoObj&);

    // usunicie elementu
    virtual bool remove(GeoObj&);

    // virtual destructor
    virtual ~GeoGroup() {
    }
};

}  // przestrze nazw Geo

#endif  // GEOGROUP_HPP

