/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include "geogroup.hpp"
#include <algorithm>

namespace Geo {

/* add
 * - umieszcza element w grupie
 */
void GeoGroup::add(GeoObj& obj)
{
    // wstawia adres obiektu przekazanego jako parametr
    elems.push_back(&obj);
}

/* draw
 * - rysuje wszystkie elementy biorc pod uwag pooenie grupy
 */
void GeoGroup::draw() const
{
    for (unsigned i=0; i<elems.size(); ++i) {
        elems[i]->move(refpoint);   // dodaje przesunicie zwizane z pooeniem grupy
        elems[i]->draw();           // rysuje element
        elems[i]->move(-refpoint);  // odejmuje przesunicie
    }
}

/* remove
 * - usuwa element
 */
bool GeoGroup::remove(GeoObj& obj)
{
    // wyszukuje pierwszy element o podanym adresie i usuwa go
    // zwraca rezultat operacji
    std::vector<GeoObj*>::iterator pos;
    pos = std::find(elems.begin(),elems.end(),&obj);
    if (pos != elems.end()) {
        elems.erase(pos);
        return true;
    }
    else {
        return false;
    }
}

}  // przestrze nazw Geo

