/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef FRACTION_HPP
#define FRACTION_HPP

// docza standardowe pliki nagwkowe
#include <iostream>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class Fraction {
  protected:
    int numer;
    int denom;

  public:
    /* klasa wyjtku
     */
    class DenomIsZero {
    };

    /* konstruktor domylny i konstruktor o jednym i dwch parametrach
     */
    Fraction(int = 0, int = 1);

    /* mnoenie
     * - globalna funkcja zaprzyjaniona
     *   umoliwiajca automatyczn konwersj typu pierwszego argumentu operatora
     */
    friend Fraction operator * (const Fraction&, const Fraction&);

    /* przypisanie z mnoeniem
     * - nowo: funkcja wirtualna
     */
    virtual const Fraction& operator *= (const Fraction&);

    /* porwnanie
     * - globalna funkcja zaprzyjaniona
     *   umoliwiajca automatyczn konwersj typu pierwszego argumentu operatora
     */
    friend bool operator < (const Fraction&, const Fraction&);

    /* zapis i odczyt ze strumienia
     * - nowo: funkcje wirtualne
     */
    virtual void printOn(std::ostream&) const;
    virtual void scanFrom(std::istream&);

    /* konwersja do typu double
     * - nowo: funkcja wirtualna
     */
    virtual double toDouble() const;

    // nowo: virtual destructor (without instructions)
    virtual ~Fraction() {
    }
};

/* operator *
 * - globalna funkcja zaprzyjaniona
 * - zdefiniowana jako funkcja rozwijana w miejscu wywoania
 */
inline Fraction operator * (const Fraction& a, const Fraction& b)
{
    /* mnoy liczniki i mianowniki
     */
    return Fraction(a.numer * b.numer, a.denom * b.denom);
}

/* standardowy operator wyjcia
 * - globalnie przeciony i zdefiniowany jako funkcja rozwijana w miejscu wywoania
 */
inline
std::ostream& operator << (std::ostream& strm, const Fraction& f)
{
    f.printOn(strm);    // wywouje funkcj skadow
    return strm;        // zwraca strumie umoliwiajc tworzenie acuchw wywoa
}

/* standardowy operator wejcia
 * - globalnie przeciony i zdefiniowany jako funkcja rozwijana w miejscu wywoania
 */
inline
std::istream& operator >> (std::istream& strm, Fraction& f)
{
    f.scanFrom(strm);   // wywouje funkcj skadow
    return strm;        // zwraca strumie umoliwiajc tworzenie acuchw wywoa
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // FRACTION_HPP

