/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef COORD_HPP
#define COORD_HPP

// plik nagwkowy obsugi wejcia i wyjcia
#include <iostream>

namespace Geo {

/* class Coord
 * - klasa pomocnicza w stosounku do obiektw graficznych
 * - nie bierze udziau w dziedziczeniu
 */
class Coord {
  private:
    int x;     // wsprzdna X
    int y;     // wsprzdna Y 

  public:
    // konstruktor domylny i konstruktor o dwch parametrach
    Coord() : x(0), y(0) {     // wartoci domylne rwne 0
    }
    Coord(int newx, int newy) : x(newx), y(newy) {
    }

    Coord operator + (const Coord&) const;    // dodawanie
    Coord operator - () const;                // negacja
    void  operator += (const Coord&);         // +=
    void  printOn(std::ostream& strm) const;  // wywietlanie
};

/* operator +
 * - dodaje wsprzdne X i Y 
 */
inline Coord Coord::operator + (const Coord& p) const
{
    return Coord(x+p.x,y+p.y);
}

/* jednoargumentowy operator -
 * - zmienia znak wsprzdnych X i Y 
 */
inline Coord Coord::operator - () const
{
    return Coord(-x,-y);
}

/* operator +=
 * - dodaje przesunicie do wsprzdnych X i Y 
 */
inline void Coord::operator += (const Coord& p)
{
    x += p.x;
    y += p.y;
}

/* printOn()
 * - wywietla par wsprzdnych
 */
inline void Coord::printOn(std::ostream& strm) const
{
    strm << '(' << x << ',' << y << ')';
}

/* operator <<
 * - konwersja standardowego operatora wyjcia
 */
inline std::ostream& operator<< (std::ostream& strm, const Coord& p)
{
    p.printOn(strm);
    return strm;
}

}  // przestrze nazw Geo

#endif // COORD_HPP

