/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef CIRCLE_HPP
#define CIRCLE_HPP

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// plik nagwkowy zawierajcy deklaracj klasy bazowej
#include "geoobj.hpp"

namespace Geo {

/* klasa Circle
 * - pochodna klasy GeoObj
 * - dane skadowe
 *     - rodek okrgu (pooenie okrgu, dziedziczona)
 *     - promie okrgu (nowa)
 */
class Circle : public GeoObj {
  protected:
    unsigned radius;    // promie

  public:
    // konstruktor, ktrego parametrami s rodek i promie okrgu
    Circle(const Coord& m, unsigned r)
         : GeoObj(m), radius(r) {
    }

    // rysuje obiekt geometryczny (implementacja)
    virtual void draw() const;

    // destruktor wirtualny
    virtual ~Circle() {
    }
};

/* rysowanie
 * - zdefiniowana jako funkcja rozwijana w miejscu wywoania
 */
inline void Circle::draw() const
{
    std::cout << "Okrg o rodku w punkcie " << refpoint
              << " i promieniu " << radius << std::endl;
}

}  // przestrze nazw Geo

#endif // CIRCLE_HPP

