/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef CAR_HPP
#define CAR_HPP

// plik nagwkowy wejcia i wyjcia
#include <iostream>

namespace CPPBook {

/* klasa Car 
 * - przygotowana do dziedziczenia
 */
class Car {
  protected:
    int km;                      // przebieg

  public:
    // konstruktor domylny i konstruktor o jednym parametrze
    Car(int d = 0) : km(d) {     // inicjuje przebieg
    }

    // przebywa podany dystans
    virtual void travel(int d) {
        km += d;                 // zwiksza przebieg
    }

    // wywietla przebieg
    virtual void printTraveled() {
        std::cout << "Samochd przejecha dotd  "
                  << km << " km " << std::endl;
    }

    // destruktor wirtualny 
    virtual ~Car() {
    }
};

}  // przestrze nazw CPPBook

#endif    // CAR_HPP

