/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef BOAT_HPP
#define BOAT_HPP

// plik nagwkowy wejcia i wyjcia
#include <iostream>

namespace CPPBook {

/* klasa Boat 
 * - przygotowana do dziedziczenia
 */
class Boat {
  protected:
    int sm;                      // przebieg (w milach morskich)

  public:
    // konstruktor domylny i konstruktor o jednym parametrze
    Boat(int d = 0) : sm(d) {    // inicjuje przebieg
    }

    // przebywa podany dystans
    virtual void travel(int d) {
        sm += d;                 // zwiksza przebieg
    }

    // output distance traveled
    virtual void printTraveled() {
        std::cout << "dka przepyna dotd  "
                  << sm << " mil morskich " << std::endl;
    }

    virtual ~Boat() {            // destruktor wirtualny
    }
};

}  // przestrze nazw CPPBook

#endif    // BOAT_HPP

