/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef AMPH_HPP
#define AMPH_HPP

// docza pliki nagwkowe klas bazowych
#include "car.hpp"
#include "boat.hpp"

namespace CPPBook {

/* Amph class
 * - pochodna klas Car i Boat
 * - przygotowana do dalszego dziedziczenia
 */
class Amph : public Car, public Boat {
  public:
    /* konstruktor domylny oraz konstruktor o jednym i dwch parametrach
     * - konstruktor klasy Car wywoywany jest z pierwszym parametrem,
     * - konstruktor klasy Boat wywoywany jest z drugim parametrem
     */
    Amph(int k = 0, int s = 0) : Car(k), Boat(s) {
        // inicjacja nie wymaga dodatkowych czynnoci
    }

    // wywietla przebieg amfibii
    virtual void printTraveled() {
        std::cout << "Amfibia przebya dotd "
                  << km << " km oraz " << sm << " mil morskich " << std::endl;
    }

    // destruktor wirtualny 
    virtual ~Amph() {
    }
};

}  // przestrze nazw CPPBook

#endif    // AMPH_HPP

