/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <set>
#include <vector>
#include <algorithm>
#include <iterator>
#include <iostream>

int add10(int elem)
{
    return elem + 10;
}

int main()
{
    std::set<int>    coll1;
    std::vector<int> coll2;

    // wstawia elementy o wartociach od 1 do 9 do kontenera coll1
    for (int i=1; i<=9; ++i) {
        coll1.insert(i);
    }

    // wywietla elementy kontenera coll1
    copy(coll1.begin(), coll1.end(),                  // rdo: coll1
         std::ostream_iterator<int>(std::cout," "));  // cel: cout
    std::cout << std::endl;

    // przeksztaca elementy coll1 do coll2
    // - dodajc warto 10
    transform(coll1.begin(),coll1.end(),    // rdo
              std::back_inserter(coll2),    // cel (wstawiania)
              add10);                       // operacja

    // wywietla elementy kontenera coll2
    copy(coll2.begin(), coll2.end(),                  // rdo: coll1
         std::ostream_iterator<int>(std::cout," "));  // cel: cout
    std::cout << std::endl;

}

