/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>
#include <list>
#include <deque>
#include <algorithm>
#include "countptr.hpp"
using namespace std;

void printCountedPtr(CountedPtr<int> elem)
{
    cout << *elem << ' ';
}

int main()
{
    // typ inteligentnych wskanikw
    typedef CountedPtr<int> IntPtr;

    // dwa rne kontenery
    deque<IntPtr> coll1;
    list<IntPtr> coll2;

    // tablica wartoci pocztkowych 
    static int values[] = { 3, 5, 9, 1, 6, 4 };

    /* tworzy elementy i wstawia do kontenerw
     * - do coll1 w tej samej kolejnoci, co w tablicy values
     * - do coll2 w odwrotnej kolejnoci
     */
    for (unsigned i=0; i<sizeof(values)/sizeof(values[0]); ++i) {
        IntPtr ptr(new int(values[i]));
        coll1.push_back(ptr);
        coll2.push_front(ptr);
    }

    // wywietla zawarto obu kontenerw
    for_each(coll1.begin(), coll1.end(), printCountedPtr);
    cout << endl;
    for_each(coll2.begin(), coll2.end(), printCountedPtr);
    cout << endl << endl;

    /* modyfikuje elementy kontenerw
     * - podnosi do kwadratu trzeci element kontenera coll1
     * - zmienia znak pierwszego elementu kontenera coll1
     * - zmienia warto pierwszego elementu kontenra coll2 na 0
     */
    *coll1[2] *= *coll1[2];
    (**coll1.begin()) *= -1;
    (**coll2.begin()) = 0;

    // ponownie wywietla zawarto obu kontenerw
    for_each(coll1.begin(), coll1.end(), printCountedPtr);
    cout << endl;
    for_each(coll2.begin(), coll2.end(), printCountedPtr);
    cout << endl;
}

