/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagwkowy funkcji zwizanych z operatorem new
#include <new>

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// deklaracja wyprzedzajca
static void myNewHandler();

// wskanik zarezerwowanej pamici (buforw bezpieczestwa)
static char* reserveMemory1;
static char* reserveMemory2;

void initNewHandler()
{
    // rezerwuje pami 
    reserveMemory1 = new char[1000000];
    reserveMemory2 = new char[100000];

    // instauje now funkcj obsugi
    std::set_new_handler(&myNewHandler);
}

static void myNewHandler()
{
    static bool firstKiss = true;

    // - pierwsze wywoanie:  zwalnia pierwszy bufor bezpieczestwa
    // - drugie wywoanie:  wyrzuca wyjtek i zwalnia drugi bufor bezpieczestwa
    if (firstKiss) {
        // program dziaa do drugiego wywoania funkcji obsugi
        firstKiss = false;

        // zwalnia pierwszy bufor bezpieczestwa
        delete [] reserveMemory1;

        // wywietla ostrzeenie za pomoc standardowego kanau bdw
        std::cerr << "Ostrzeenie: program zuy prawie ca dostpn pami" << std::endl;
    }
    else {
        // zwalnia drugi bufor bezpieczestwa
        delete [] reserveMemory2;

        // wywietla komunikat o bdzie za pomoc standardowego kanau bdw
        std::cerr << "brak pamici" << std::endl;

        // wyrzuca odpowiedni wyjtek
        throw std::bad_alloc();
    }
}

