/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagwkowy funkcji zwizanych z operatorem new
#include <new>

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// deklaracja wyprzedzajca
static void myNewHandler();

// rezerwowana pami
static char* reserveMemory;

void initNewHandler()
{
    // przydziela pami bufora bezpieczestwa
    reserveMemory = new char[100000];

    // instaluje now funkcj wyrzucajc wyjtki operatora new
    std::set_new_handler(&myNewHandler);
}

static void myNewHandler()
{
    // zwalnia zarezerwowan pami
    delete [] reserveMemory;

    // wywietla komunikat o bdzie za pomoc standardowego kanau bdw
    std::cerr << "brak wolnej pamici (program korzysta z bufora bezpieczestwa)"
              << std::endl;

    // wyrzuca odpowiedni wyjtek
    throw std::bad_alloc();
}

