/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagwkowy funkcji zwizanych z operatorem new
#include <new>

// standardowe pliki nagwkowe
#include <iostream>
#include <cstdlib>

/* myNewHandler()
 * - wywietla komunikat o bdzie i koczy dziaanie programu
 */
void myNewHandler()
{
    // wywietla komunikat o bdzie za pomoc standardowego kanau bdw
    std::cerr << "brak wolnej pamici..." << std::endl;

    // wyrzuca odpowiedni wyjtek
    throw std::bad_alloc();
}

int main()
{
    try {
        // instaluje wasn funkcj wyrzucajc wyjtki operatora new
        std::set_new_handler(&myNewHandler);

        // testuje jej dziaanie za pomoc nieskoczonej ptli
        // przydzielajcej pami
        for (;;) {
            new char[1000000];
        }

        // aden komputer nie posiada nieskoczonej pamici
        std::cout << "Magia?" << std::endl;
    }
    catch (const std::bad_alloc& e) {
        std::cerr << "Wyjtek: " << e.what() << std::endl;
        return EXIT_FAILURE;
    }
}

