/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef COUNTED_PTR_HPP
#define COUNTED_PTR_HPP

/* szablon klasy inteligentnych wskanikw implementujcy semantyk referencji
 * - usuwa wskazywany obiekt, gdy usuwany jest 
 *     ostatni jego wskanik CountedPtr
 */
template <typename T>
class CountedPtr {
  private:
    T* ptr;        // wskanik rzeczywistego obiektu
    long* count;   // referencja liczby wskanikw obiektu

  public:
    // inicjacja za pomoc zwykego wskanika
    // - p musi by wartoci zwrcon przez operator new
    explicit CountedPtr (T* p=0)
     : ptr(p), count(new long(1)) {
    }

    // konstruktor kopiujcy
    CountedPtr(const CountedPtr<T>& p) throw()
     : ptr(p.ptr), count(p.count) {  // kopiuje obiekt i licznik
        ++*count;                    // zwiksza licznik referencji
    }

    // destruktor
    ~CountedPtr () throw() {
        release();             // zwalnia referencj obiektu
    }

    // przypisanie
    CountedPtr<T>& operator= (const CountedPtr<T>& p) throw() {
        if (this != &p) {       // sprawdza, czy nie jest to referencja do samego siebie
            release();          // zwalnia referencj poprzedniego obiektu
            ptr = p.ptr;        // kopiuje nowy obiekt
            count = p.count;    // kopiuje licznik
            ++*count;           // zwiksza licznik referencji
        }
        return *this;
    }

    // dostp do obiektu
    T& operator*() const throw() {
        return *ptr;
    }

    // dostp do skadowej obiektu
    T* operator->() const throw() {
        return ptr;
    }

  private:
    void release() {
        ++*count;               // zmniejsza licznik referencji
        if (*count == 0) {      // gdy nie ma ju referencji
             delete count;      // usuwa licznik
             delete ptr;        // usuwa obiekt
        }
    }
};

#endif /*COUNTED_PTR_HPP*/

