/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>

class MyClass {
  public:
    void func1() {
        std::cout << "call of func1()" << std::endl;
    }
    void func2() {
        std::cout << "call of func2()" << std::endl;
    }
};

// definuje typ: wskanik funkcji skadowej klasy MyClass,
//     ktranie posiada parametrw i nie zwraca wartoci
typedef void (MyClass::*MyClassFunction)();

// eksportowane obiekty i eksportowane funkcje skadowe
void* objPtr;
void* objfpPtr;

void exportObjectAndFunction(void* op, void* fp)
{
    objPtr = op;
    objfpPtr = fp;
}

void callMyClassFunc(void* op, void* fp)
{
    // rzutowanie z powrotem do oryginalnego typu
    MyClass* myObjPtr = static_cast<MyClass*>(op);
    MyClassFunction* myFuncPtr
                      = static_cast<MyClassFunction*>(fp);

    // wywoanie przekazanej funkcji skadowej dla przekazanego obiektu
    (myObjPtr->*(*myFuncPtr))();
}

int main()
{
    // obiekt klasy MyClass
    MyClass x;

    // wskanik funkcji skadowej klasy MyClass
    MyClassFunction funcPtr;

    // wskazuje func1()
    funcPtr = & MyClass::func1;

    // eksportuje obiekt i funkcj skadow
    exportObjectAndFunction(&x, &funcPtr);

    // wywouje wyeksportowan funkcj skadow
    // dla wyeksportowanego obiektu
    callMyClassFunc(objPtr, objfpPtr);
}

