/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#include <iostream>

class MyClass {
  public:
    void func1() {
        std::cout << "wywoanie funkcji func1()" << std::endl;
    }
    void func2() {
        std::cout << "wywoanie funkcji func2()" << std::endl;
    }
};

// definiuje typ: wskanik funkcji skadowej klasy MyClass,
//     ktra nie posiada parametr i nie zwraca wartoci
typedef void (MyClass::*MyClassFunction) ();

int main()
{
    // wskanik funkcji skadowej klasy MyClass
    MyClassFunction funcPtr;

    // obiekt klasy MyClass
    MyClass x;

    // wskazuje funkcj skadow func1()
    funcPtr = & MyClass::func1;

    // wywouje funkcj skadow wskazywan przez funcPtr dla obiektu x
    (x.*funcPtr)();

    // wskazuje funkcj skadow func2()
    funcPtr = & MyClass::func2;

    // wywouje funkcj skadow wskazywan przez funcPtr dla obiektu x
    (x.*funcPtr)();
}

