/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef STRING_HPP
#define STRING_HPP

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class String {
  public:
    class reference {
      friend class String;  // String posiada dostp do skadowych prywatnych klasy reference
      private:
        char& ch;           // wewntrzna referencja znaku acucha
        reference(char& c) : ch(c) {     // konstruktor
        }
        reference(const reference&);     // kopiowanie zabronione
      public:
        reference& operator= (char c) {  // przypisania
            ch = c;
            return *this;
        }
        reference& operator= (const reference& r) {
            ch = r.ch;
            return *this;
        }
        operator char() {                // operator konwersji
            return ch;
        }
    };

    // klasa wyjtku:
    // - deklaracja wyprzedzajca, poniewa klasa zawiera skadow typu String
    class RangeError;

  protected:
    char*    buffer;    // sekwencja znakw jako tablica dynamiczna
    unsigned len;       // bieca liczba znakw acucha
    unsigned size;      // rozmiar bufora

  public:
    // konstruktor domylny i konstruktor o parametrze typu char* 
    String(const char* = "");

    // ze wzgldu na skadowe dynamiczne:
    String(const String&);              // konstruktor kopiujcy
    String& operator= (const String&);  // przypisanie
    virtual ~String();                  // destruktor (nowo: wirtualny)

    // porwnanie acuchw
    friend bool operator== (const String&, const String&);
    friend bool operator!= (const String&, const String&);

    // konkatenacja acuchw
    friend String operator+ (const String&, const String&);

    // zapis do strumienia
    virtual void printOn(std::ostream&) const;

    // odczyt ze strumienia
    virtual void scanFrom(std::istream&);

    // dugo acucha
    unsigned length() const {
        return len;
    }

    // operator [] dla zmiennych i staych
    reference operator [] (unsigned);
    char      operator [] (unsigned) const;

  private:
    /* konstruktor, ktreo parametrami s dugo i bufor
     * - uzywany wewntrznie przez operator +
     */
    String(unsigned, char*);
};

class String::RangeError {
  public:
    int    index;    // niedozwolona warto indeksu
    String value;    // acuch, dla ktrego wystpi bd

    // konstruktor (inicjuje skadowe index i value)
    RangeError (const String& s, int i) : index(i), value(s) {
    }
};

// standardowy operator wyjcia
inline std::ostream& operator << (std::ostream& strm, const String& s)
{
    s.printOn(strm);    // zapisuje acuch do strumienia
    return strm;        // zwraca strumie
}

// standardowy operator wejcia 
inline std::istream& operator >> (std::istream& strm, String& s)
{
    s.scanFrom(strm);   // odczytuje acuch ze strumienia
    return strm;        // zwraca strumie
}

/* operator !=
 * - zaimplementowany za pomoc operator ==
 * jako funkcja rozwijana w miejscu wywoania
 */
inline bool operator!= (const String& s1, const String& s2) {
    return !(s1==s2);
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // STRING_HPP

