/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

/* operator [] dla zmiennych
 */
String::reference String::operator [] (unsigned i)
{
    // niedozwolona wartoc indeksu?
    if (i >= len) {
        // wyrzuca wyjtek zawierajcy warto indeksu
        throw RangeError(i);
    }

    return reference(buffer[i]);
}

/* operator [] dla staych
 */
char String::operator [] (unsigned i) const
{
    // niedozwolona warto indeksu?
    if (i >= len) {
        // wyrzuca wyjtek zawierajcy warto indeksu
        throw RangeError(i);
    }

    return buffer[i];
}

