/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef STRING_HPP
#define STRING_HPP

// plik nagwkowy wejcia i wyjcia
#include <iostream>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class String {
  public:
    class reference {
      friend class String;     // klasa String posiada dostp do klasy reference
      private:
        char& ch;              // referencja znaku acucha

        // konstruktor (moe by wywoany tylko przez klas String )
        reference(char& c) : ch(c) {    // tworzy referencj
        }

        reference(const reference&);     // zabrania kopiowania
      public:

        // przypisania znaku bd referencji jest dozwolone
        reference& operator= (char c) {
            ch = c;
            return *this;
        }
        reference& operator= (const reference& r) {
            ch = r.ch;
            return *this;
        }

        // konwersja do typu char
        operator char() {
            return ch;
        }
    };

  private:
    char*    buffer;    // sekwencja znakw jako tablica dynamiczna
    unsigned len;       // bieca dugo acucha
    unsigned size;      // rozmiar bufora

  public:
    // domylny konstruktor i konstruktor, ktrego parametrem jest C-acuch
    String(const char* = "");

    // ze wzgldu na dynamiczne skadowe konieczna jest implementacja:
    String (const String&);             // konstruktora kopiujcego
    String& operator= (const String&);  // przypisania
    ~String();                          // destruktora

    // porwnanie acuchw
    friend bool operator== (const String&, const String&);
    friend bool operator!= (const String&, const String&);

    // konkatenacja acuchw
    friend String operator+ (const String&, const String&);

    // zapis do strumienia
    void printOn(std::ostream&) const;

    // odczyt ze strumienia
    void scanFrom(std::istream&);

    // dugo (liczba znakw acucha)
    unsigned length() const {
        return len;
    }

    // dostp do znakw acucha
    reference operator [] (unsigned);
    char      operator [] (unsigned) const;

  private:
    /* konstruktor acucha o zadanej dugoci i podanym buforze
     * - uywany wewntrznie przez operator +
     */
    String (unsigned, char*);
};

// standardowy operator wyjcia
inline std::ostream& operator << (std::ostream& strm, const String& s)
{
    s.printOn(strm);    // zapisuje acuch do strumienia
    return strm;        // zwraca acuch
}

// standardowy operator wejcia
inline std::istream& operator >> (std::istream& strm, String& s)
{
    s.scanFrom(strm);   // odczytuje acuch ze strumienia
    return strm;        // zwraca acuch
}

/* operator !=
 * - zaimplementowany jako funkcja rozwijana w miejscu wywoania za pomoc operatora ==
 */
inline bool operator!= (const String& s1, const String& s2) 
{
    return !(s1==s2);
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // STRING_HPP

