/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagwkowy klasy
#include "string.hpp"

// pliki nagwkowe C-acuchw
#include <cstring>
#include <cctype>

// plik nagwkowy wyjtkw
#include <stdexcept>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* konstruktor, ktrego parametrem jest C-acuch (const char*)
 * - warto domylna parametru s: pusty acuch
 */
String::String (const char* s)
{
    len = std::strlen(s);       // liczba znakw
    size = len;                 // liczba znakw okrela rozmiar bufora
    buffer = new char[size];    // przydziela pamie
    std::memcpy(buffer,s,len);  // kopiuje znaki do bufora
}

/* Konstruktor kopiujcy
 */
String::String (const String& s)
{
    len = s.len;                       // kopiuje liczb znakw
    size = len;                        // liczba znakw
                                       // okrela rozmiar bufora
    buffer = new char[size];           // przydziela pami
    std::memcpy(buffer,s.buffer,len);  // kopiuje znaki do bufora
}

/* destruktor
 */
String::~String ()
{
    // zwalnia pami przydzielon wczeniej za pomoc operatora new[]
    delete [] buffer;
}

/* operator =
 * - przypisanie
 */
String& String::operator= (const String& s)
{
    // przypisanie acucha samemu sobie nie wymaga adnej operacji
    if (this == &s) {
        return *this;        // zwraca acuch
    }

    len = s.len;             // kopiuje liczb znakw

    // jeli bufor jest za may, to przydziela odpowiedni obszar pamici
    if (size < len) {
        delete [] buffer;         // zwalnia poprzedni pami
        size = len;               // liczba znakw okrela rozmiar nowego bufora
        buffer = new char[size];  // przydziela pami
    }

    std::memcpy(buffer,s.buffer,len);  // kopiuje znaki

    return *this;            // zwraca zmodyfikowany acuch
}

/* operator ==
 * - porwnuje dwa acuchy
 * - globalna funkcja zaprzyjaniona, moliwa 
 *     automatyczna konwersja typu pierwszego argumentu
 */
bool operator== (const String& s1, const String& s2)
{
    return s1.len == s2.len &&
           std::memcmp(s1.buffer,s2.buffer,s1.len) == 0;
}

/* operator +
 * - czy dwa acuchy
 * - globalna funkcja zaprzyjaniona, moliwa 
 *     automatyczna konwersja typu pierwszego argumentu
 */
String operator+ (const String& s1, const String& s2)
{
    // przydziela bufor, ktry pomieci acuch wynikowy
    char* buffer = new char[s1.len+s2.len];

    // kopije znaki do bufora
    std::memcpy (buffer,        s1.buffer, s1.len);
    std::memcpy (buffer+s1.len, s2.buffer, s2.len);

    // tworzy odpowiedni obiekt klasy String i zwraca go
    return String(s1.len+s2.len, buffer);
}

/* konstruktor tworzcy niezainicjowany acuch o podanej dugoci
 * - wykorzystywany wewntrznie przez operator +
 */
String::String(unsigned l, char* buf)
{
    len = l;       // kopiuje liczb znakw
    size = len;    // liczba znakw okrela rozmiar bufora
    buffer = buf;  // kopiuje adres bufora
}

/* zapis acucha do strumienia
 */
void String::printOn(std::ostream& strm) const
{
    // zapisuje acuch
    strm.write(buffer,len);
}

void String::scanFrom (std::istream& strm)
{
    char c;

    len = 0;            // pocztkowo acuch jest pusty

    strm >> std::ws;    // pomija pocztkowe odstpy

    /* tak dugo jak strumie strm 
     * po wczytaniu znaku c umoliwia odczyt kolejnych znakw
     */
    while (strm.get(c)) {       // >> bdzie pomija pocztkowe odstpy 

        /* jeli na kocu acucha znajduje si odstp,
         * RETURN
         */
        if (std::isspace(c)) {
            return;
        }

        /* jeli bufor jest za may, powiksza go
         */
        if (len >= size) {
            char* tmp = buffer;           // wskanik starego bufora
            size = size*2 + 32;           // zwiksza rozmiar bufora
            buffer = new char[size];      // przydziela pami nowego bufora
            std::memcpy(buffer,tmp,len);  // kopiuje znaki
            delete [] tmp;                // zwalnia pami staregom bufora
        }

        // wprowadza nowe znaki
        buffer[len] = c;
        ++len;
    }

    // koniec wczytywania ze wzgldu na bd lub koniec pliku
}

/* operator [] dla zmiennych
 */
String::reference String::operator [] (unsigned idx)
{
    // niedozwolona warto indeksu?
    if (idx >= len) {
        throw std::out_of_range("niedozwolona warto indeksu");
    }

    return reference(buffer[idx]);
}

/* operator [] dla staych
 */
char String::operator [] (unsigned idx) const
{
    // niedozwolona warto indeksu?
    if (idx >= len) {
        throw std::out_of_range("niedozwolona warto indeksu");
    }

    return buffer[idx];
}

} // **** Koniec przestrzeni nazw CPPBook ********************************


