/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

void String::scanFrom(std::istream& strm)
{
    char c;

    len = 0;            // pocztkowo acuch jest pusty

    strm >> std::ws;    // pomija pocztkowe odstpy

    /* tak dugo jak strumie strm 
     * po wczytaniu znaku c umoliwia odczyt kolejnych znakw
     */
    while (strm.get(c)) {       // >> bdzie pomija pocztkowe odstpy 

        /* jeli na kocu acucha znajduje si odstp,
         * RETURN
         */
        if (std::isspace(c)) {
            return;
        }

        /* jeli bufor jest za may, powiksza go
         */
        if (len >= size) {
            char* tmp = buffer;           // wskanik starego bufora
            size = size*2 + 32;           // zwiksza rozmiar bufora
            buffer = new char[size];      // przydziela pami nowego bufora
            std::memcpy(buffer,tmp,len);  // kopiuje znaki
            delete [] tmp;                // zwalnia pami staregom bufora
        }

        // wprowadza nowe znaki
        buffer[len] = c;
        ++len;
    }

    // koniec wczytywania ze wzgldu na bd lub koniec pliku
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

