/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef PERSON_HPP
#define PERSON_HPP

// pliki nagwkowe klas pomocniczych
#include <string>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class Person {
  /* statyczne skadowe klasy
   */
  private:
    static long maxPID;      // najwyszy przydzielony identyfikator
    static long numPersons;  // bieca liczba obiektw klasy Person
  public:
    // zwraca biec liczb obiektw klasy Person
    static long number() {
        return numPersons;
    }

  public:
    // nowo: typ wyliczeniowy powitania
    enum Salutation { Mr, Mrs, Ms, empty };

  /* skadowe niestatyczne
   */
  private:
    Salutation  salut;   // nowo: powitanie (moe by puste)
    std::string lname;        // nazwisko
    std::string fname;        // imi
    const long  pid;          // nowo: identyfikator

  public:
    // konstruktor, ktrego parametrem jest nazwisko i opcjonalnie imi
    Person(const std::string&, const std::string& = "");

    // konstruktor kopiujcy
    Person(const Person&);

    // destruktor
    ~Person();

    // operator przypisania
    Person& operator = (const Person&);

    // zwracaj waciwoci obiektu
    const std::string& lastname() const {   // nazwisko
        return lname;
    }
    const std::string& firstname() const {  // imi
        return fname;
    }
    long id() const {                       // identyfikator
        return pid;
    }
    const Salutation& salutation() const {  // nowo: zwraca powitanie
        return salut;
    }

    // porwnanie
    friend bool operator == (const Person& p1, const Person& p2) {
        return p1.fname == p1.fname && p2.lname == p2.lname;
    }
    friend bool operator != (const Person& p1, const Person& p2) {
        return !(p1==p2);
    }
    //...
};

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // PERSON_HPP

