/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// docza plik nagwkowy klasy
#include "person.hpp"

// **** Pocztek przestrzeni nazwCPPBook ********************************
namespace CPPBook {

/* nowo: inicjuje skadowe statyczne
 */
long Person::maxPID = 0;
long Person::numPersons = 0;

/*  konstruktor, ktrego parametrami s nazwisko i imi
 * - domylna warto imienia: pusty acuch znakw
 * - imi i nazwisko s inicjowane za pomoc listy inicjacji
 * - nowo: identyfikator jest inicjowany bezporednio
 */
Person::Person(const std::string& ln, const std::string& fn)
  : lname(ln), fname(fn), pid(++maxPID)
{
    ++numPersons;  // zwiksza licznik osb
}

/* nowo: konstruktor kopiujcy
 */
Person::Person(const Person& p)
  : lname(p.lname), fname(p.fname), pid(++maxPID)
{
    ++numPersons;  // zwiksza licznik osb
}

/* nowo: destruktor
 */
Person::~Person()
{
    --numPersons;  // zmniejsza liczb osb
}

/* nowo: operator przypisania
 */
Person& Person::operator = (const Person& p)
{
    if (this == &p) {
        return *this;
    }

    // przypisuje wartoci wszystkim skadowym oprcz identyfikatora
    lname = p.lname;
    fname = p.fname;

    return *this;
}

} // **** Koniec przestrzeni nazw CPPBook ********************************


