/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef PERSON_HPP
#define PERSON_HPP

// pliki nagwkowe klas pomocniczych
#include <string>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class Person {
  private:
    std::string fname;        // imi
    std::string lname;        // nazwisko

  public:
    // konstruktor, ktrego parametrem jest nazwisko i opcjonalnie imi
    Person(const std::string&, const std::string& = "");

    // zwracaj waciwoci obiektu
    const std::string& firstname() const {     // imi
        return fname;
    }
    const std::string& lastname() const {      // nazwisko
        return lname;
    }

    // porwnanie
    bool operator == (const Person& p) const {
        return fname == p.fname && lname == p.lname;
    }
    bool operator != (const Person& p) const {
        return fname != p.fname || lname != p.lname;
    }
    //...
};

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // PERSON_HPP

