/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef COLSTRING_HPP
#define COLSTRING_HPP

// plik nagwkowy klasy bazowej
#include "string.hpp"

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* klasa ColString
 * - pochodna klasy String
 */
class ColString : public String {
  protected:
    String col;    // kolor acucha

  public:
    // konstruktor domylny i konstruktor o jednym i dwch parametrach typu String
    ColString(const String& s = "", const String& c = "black")
        : String(s), col(c) {
    }

    // zwracaj i inicjuj skadow koloru
    const String& color() {
        return col;
    }
    void color(const String& newColor) {
        col = newColor;
    }

    // zapis i odczyt ze strumienia
    virtual void printOn(std::ostream&) const;
    virtual void scanFrom(std::istream&);

    // porwnanie acuchw ColStrings
    friend bool operator== (const ColString& s1,
                            const ColString& s2) {
        return static_cast<const String&>(s1)
                 == static_cast<const String&>(s2)
               && s1.col == s2.col;
    }
    friend bool operator!= (const ColString& s1,
                            const ColString& s2) {
        return !(s1==s2);
    }
};

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif // COLSTRING_HPP

