/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// docza standardowe pliki nagwkowe 
#include <iostream>
#include <cstdlib>

// docza pliki nagwkowe uywanych klas
#include "frac.hpp"

int main()
{
    CPPBook::Fraction x;     // deklaracja uamka x

    /* prbuje wczyta uamek i obsuy
     * wyjtek typu DenomIsZero
     */
    try {
        int n, d;
        std::cout << "licznik: ";
        if (! (std::cin >> n)) {
            // bd wejcia: wywietla komunikat i koczy dziaanie programu
            std::cerr << "Bd podczas wprowadzania licznika"
                      << std::endl;
            return EXIT_FAILURE;
        }
        std::cout << "mianownik: ";
        if (! (std::cin >> d)) {
            // bd wejcia: wywietla komunikat i koczy dziaanie programu
            std::cerr << "Bd podczas wprowadzania mianownika"
                      << std::endl;
            return EXIT_FAILURE;
        }
        x = CPPBook::Fraction(n,d);
        std::cout << "Wprowadzony uamek: " << x << std::endl;
    }
    catch (const CPPBook::Fraction::DenomIsZero&) {
        /* wywietla odpowiedni komunikat i koczy dziaanie programu
         */
        std::cerr << "Bd wejcia: mianownik musi by rny od 0"
                  << std::endl;
        return EXIT_FAILURE;
    }

    // program dociera do tego punktu, gdy uamek x zosta wczytany poprawnie
    //...
}

