/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// docza standardowe pliki nagwkowe 
#include <iostream>
#include <cstdlib>

// docza pliki nagwkowe uywanych klas
#include "frac.hpp"

int main()
{
    const CPPBook::Fraction a(7,3);      // deklaracja staego uamka a
    CPPBook::Fraction x;                 // deklaracje uamka x

    // nowo: wywietla uamek posugujc si operatorem wyjcia
    std::cout << a << std::endl;

    // nowo: wczytuje uamek x
    std::cout << "podaj uamek (licznik/mianownik): ";
    if (! (std::cin >> x)) {
        // bd wejcia: wywietla komunikat i koczy dziaanie programu
        std::cerr << "Bd podczas wprowadzania uamka" << std::endl;
        return EXIT_FAILURE;
    }
    std::cout << "Wprowadzony uamek: " << x << std::endl;

    // jak dugo x mniejsze ni 1000
    while (x < CPPBook::Fraction(1000)) {
        // mnoy x przez a
        x = x * a;
        // nowo: wywietla uamek posugujc si operatorem wyjcia
        std::cout << x << std::endl;
    }
}

