/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef FRACTION_HPP
#define FRACTION_HPP

// docza standardowe pliki nagwkowe
#include <iostream>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class Fraction {

  private:
    int numer;
    int denom;

  public:
    /* domylny konstruktor i konstruktor o jednym i dwch parametrach
     */
    Fraction (int = 0, int = 1);

    /* mnoenie
     * - nowo: globalna funkcja zaprzyjaniona, umoliwia
     * automatyczn konwersj typu dla pierwszego argumentu
     */
    friend Fraction operator * (const Fraction&, const Fraction&);
    
    // przypisanie z mnoeniem
    const Fraction& operator *= (const Fraction&);
    
    /* porwnanie
     * - nowo: globalna funkcja zaprzyjaniona, umoliwia
     * automatyczn konwersj typu dla pierwszego argumentu
     */
    friend bool operator < (const Fraction&, const Fraction&);

    // zapis do strumienia
    void printOn(std::ostream&) const;

    // odczyt ze strumienia
    void scanFrom (std::istream&);

    // jawna konwersja do typu double
    double toDouble () const;
};

/* operator *
 * - nowo: globalna funkcja zaprzyjaniona
 * - zdefiniowany jako funkcja rozwijana w miejscu wywoania
 */
inline Fraction operator * (const Fraction& a, const Fraction& b)
{
    /* mnoy liczniki i mianowniki
     * - nadal nie skraca uamka
     */
    return Fraction (a.numer * b.numer, a.denom * b.denom);
}

/* standardowy operator wyjcia
 * - globalnie przeciony i zdefiniowany jako funkcja rozwijana w miejscu
 */
inline
std::ostream& operator << (std::ostream& strm, const Fraction& f)
{
    f.printOn(strm);    // wywouje funkcj skadow
    return strm;        // zwraca strumie umoliwiajc tworzenie acuchw wywoa
}

/* standardowy operator wejcia
 * - globalnie przeciony i zdefiniowany jako funkcja rozwijana w miejscu
 */
inline
std::istream& operator >> (std::istream& strm, Fraction& f)
{
    f.scanFrom(strm);   // wywouje funkcj skadow
    return strm;        // zwraca strumie umoliwiajc tworzenie acuchw wywoa
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // FRACTION_HPP

