/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// docza plik nagwkowy zawierajcy deklaracj klasy
#include "frac.hpp"

// docza standardowe pliki nagwkowe
#include <cstdlib>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* domylny konstruktor i konstruktor o jednym i dwch parametrach
 * - domylna warto parametru n: 0
 * - domylna warto parametru d: 1
 */
Fraction::Fraction (int n, int d)
{
    /* inicjuje licznik i mianownik wartociami przekazanymi przez parametry
     * - warto 0 nie jest dozwolona dla mianownika,
     * - przenosi znak minus (jeli istnieje) z mianownika do licznika 
     */
    if (d == 0) {
        // nowo:
        std::cerr << "bd: mianownik rwny 0" << std::endl;
        std::exit(EXIT_FAILURE);
    }
    if (d < 0) {
        numer = -n;
        denom = -d;
    }
    else {
        numer = n;
        denom = d;
    }
}

/* operator *=
 */
const Fraction& Fraction::operator *= (const Fraction& f)
{
    // "x *= y"  ==>  "x = x * y"
    *this = *this * f;

    // zwraca pierwszy argument
    return *this;
}

/* operator <
 * - globalna funkcja zaprzyjaniona
 */
bool operator < (const Fraction& a, const Fraction& b)
{
    // poniewa mianownik nie moe by ujemny, to wystarcza:
    return a.numer * b.denom < b.numer * a.denom;
}

/* printOn
 * - zapis uamka do strumienia strm
 */
void Fraction::printOn (std::ostream& strm) const
{
    strm << numer << '/' << denom;
}

/* scanFrom
 * - odczyt uamka ze strumienia strm
 */
void Fraction::scanFrom (std::istream& strm)
{
    int n, d;

    // wczytuje licznik
    strm >> n;

    // wczytuje opcjonalny znak '/' i mianownik
    if (strm.peek() == '/') {
        strm.get();
        strm >> d;
    }
    else {
        d = 1;
    }

    // bd odczytu?
    if (! strm) {
        return;
    }

    // mianownik rwny 0?
    if (d == 0) {
        // ustawia znacznik failbit
        strm.clear (strm.rdstate() | std::ios::failbit);
        return;
    }

    /* przypisuje wczytane wartoci skadowym
     * - przenosi znak minus z mianownika do licznika
     */
    if (d < 0) {
        numer = -n;
        denom = -d;
    }
    else {
        numer = n;
        denom = d;
    }
}

// konwersja do typu double
double Fraction::toDouble () const
{
    // zwraca iloraz licznika i mianownika
    return double(numer)/double(denom);
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

