/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {
//...

/* nowo: scanFrom()
 * - odczyt uamka ze strumienia strm
 */
void Fraction::scanFrom(std::istream& strm)
{
    int n, d;

    // wczytuje licznik
    strm >> n;

    // wczytuje opcjonalny znak '/' i mianownik
    if (strm.peek() == '/') {
        strm.get();
        strm >> d;
    }
    else {
        d = 1;
    }

    // bd odczytu?
    if (! strm) {
        return;
    }

    // mianownik rwny 0?
    if (d == 0) {
        // ustawia znacznik failbit
        strm.clear (strm.rdstate() | std::ios::failbit);
        return;
    }

    /* przypisuje wczytane wartoci skadowym
     * - przenosi znak minus z mianownika do licznika
     */
    if (d < 0) {
        numer = -n;
        denom = -d;
    }
    else {
        numer = n;
        denom = d;
    }
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

