/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef FRACTION_HPP
#define FRACTION_HPP

// docza standardowe pliki nagwkowe
#include <iostream>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

class Fraction {

  private:
    int numer;
    int denom;

  public:
    /* konstruktor domylny oraz konstruktor o jednym i dwch parametrach
     */
    Fraction(int = 0, int = 1);

    // wywietlanie uamka (zdefiniowane jako funkcja rozwijana w miejscu)
    void print() const {
        std::cout << numer << '/' << denom << std::endl;
    }

    // mnoenie
    Fraction operator * (const Fraction&) const;

    // przypisanie z mnoeniem
    const Fraction& operator *= (const Fraction&);

    // porwnanie
    bool operator < (const Fraction&) const;
};


/* operator *
 * - zdefiniowany jako funkcja rozwijana w miejscu
 */
inline Fraction Fraction::operator * (const Fraction& f) const
{
    /* mnoy liczniki i mianowniki
     * - nie skraca uamkw
     */
    return Fraction(numer * f.numer, denom * f.denom);
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif  // FRACTION_HPP

