/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// docza plik nagwkowy zawierajcy deklaracj klasy
#include "frac.hpp"

// docza standardowe pliki nagwkowe
#include <cstdlib>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* konstruktor domylny i konstruktor o jednym i dwch parametrach
 * - warto domylna parametru n: 0
 * - warto domylna parametru d: 1
 */
Fraction::Fraction(int n, int d)
{
    /* inicjuje licznik i mianownik wartociami przekazanymi przez parametry
     * - warto 0 nie jest dozwolona dla mianownika,
     * - przenosi znak minus (jeli istnieje) z mianownika do licznika 
     */

    if (d == 0) {
        // koczy dziaanie programu i wywietla komunikat o bdzie
        std::cerr << "bd: mianownik rwny 0" << std::endl;
        std::exit(EXIT_FAILURE);
    }
    if (d < 0) {
        numer = -n;
        denom = -d;
    }
    else {
        numer = n;
        denom = d;
    }
}

/* operator *=
 */
const Fraction& Fraction::operator *= (const Fraction& f)
{
    // `x *= y'  =>  `x = x * y'
    *this = *this * f;

    // zwraca obiekt bdcy pierwszym argumentem
    return *this;
}

/* operator <
 */
bool Fraction::operator < (const Fraction& f) const
{
    // poniewa mianownik nie moe by ujemny, to wystarcza:
    return numer * f.denom < f.numer * denom;
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

