/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

#ifndef FRACTION_HPP
#define FRACTION_HPP

// docza standardowe pliki nagwkowe
#include <iostream>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* klasa Fraction 
 */
class Fraction {

  private:
    int numer;
    int denom;

  public:
    /* nowo: konstruktor domylny oraz konstruktory o jednym 
     * i dwch parametrach zostay zastpione jedn funkcj
     */
    Fraction(int = 0, int = 1);

    /* wywietlanie
     * - nowo: funkcja rozwijana w miejscu wywoania
     */
    void print() {
        std::cout << numer << '/' << denom << std::endl;
    }

    // mnoenie
    Fraction operator * (Fraction);

    // przypisanie z mnoeniem
    Fraction operator *= (Fraction);

    // porwnanie
    bool operator < (Fraction);
};

/* operator *
 * - nowo: funkcja rozwijana w miejscu wywoania
 */
inline Fraction Fraction::operator * (Fraction f)
{
    /* mnoy liczniki i mianowniki
     * - nadal nie skraca uamka
     */
    return Fraction(numer * f.numer, denom * f.denom);
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

#endif    // FRACTION_HPP

