/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

Fraction::Fraction(int n, int d)
{
    /* inicjuje licznik i mianownik wartociami przekazanymi przez parametry
     * - warto 0 nie jest dozwolona dla mianownika,
     * - przenosi znak minus (jeli istnieje) z mianownika do licznika 
     */
    if (d == 0) {
        // nowo: wyrzuca wyjtek, gdy mianownik rwny 0
        throw DenomIsZero();
    }
    if (d < 0) {
        numer = -n;
        denom = -d;
    }
    else {
        numer = n;
        denom = d;
    }
}

/* scanFrom
 * - odczyt uamka ze strumienia strm
 */
void Fraction::scanFrom(std::istream& strm)
{
    int n, d;

    // wczytuje licznik
    strm >> n;

    // wczytuje opcjonalny znak '/' i mianownik
    if (strm.peek() == '/') {
        strm.get();
        strm >> d;
    }
    else {
        d = 1;
    }

    // bd odczytu?
    if (! strm) {
        throw ReadError();
    }

    // mianownik rwny 0?
    if (d == 0) {
        // nowo: wyrzuca wyjtek, gdy mianownik rwny 0
        throw DenomIsZero();
    }

    /* przypisuje wczytane wartoci skadowym
     * - przenosi znak minus z mianownika do licznika
     */
    if (d < 0) {
        numer = -n;
        denom = -d;
    }
    else {
        numer = n;
        denom = d;
    }
}
