/* Poniszy kod pochodzi z ksiki
* "C++. Programowanie zorientowane obiektowo.
* Vademecum profesjonalisty"
* autorstwa Nicolai M. Josuttisa, wydanej
* w Polsce przez wydawnictwo HELION S.A. w 2003 roku
* (wydanie oryginalne: Wiley, 2002)
*
* (C) Copyright Nicolai M. Josuttis 2002.
* Kopiowanie, wykorzystywanie, modyfikacja
* i rozpowszechnianie niniejszego oprogramowania
* jest dozwolone pod warunkiem zamieszczenia
* niniejszej informacji o prawach autorskich.
* Oprogramowanie to jest udostpniane
* bez jakichkolwiek gwarancji.
*/

// plik nagwkowy zawierajcy deklaracj klasy
#include "frac.hpp"

// standardowe pliki nagwkowe
#include <iostream>
#include <cstdlib>

// **** Pocztek przestrzeni nazw CPPBook ********************************
namespace CPPBook {

/* domylny konstruktor
 */
Fraction::Fraction()
 : numer(0), denom(1)    // inicjuje uamek wartoci 0
{
    // nie wykonuje dodatkowych instrukcji
}

/* konstruktor liczby cakowitej
 */
Fraction::Fraction(int n)
 : numer(n), denom(1)    // inicjuje liczbnik uamka liczb cakowit
{
    // nie wykonuje dodatkowych instrukcji
}

/* konstruktor uamka o okrelonym liczniku i mianowniku
 */
Fraction::Fraction(int n, int d)
 : numer(n), denom(d)    // inicjuje licznik i mianownik przekazanymi mu wartociami
{
    // mianownik rwny 0 jest niedozwolony
    if (d == 0) {
        // koczy prac programu wywietlajc komunikat o bdzie
        std::cerr << "bd: mianownik rwny 0" << std::endl;
        std::exit(EXIT_FAILURE);
    }
}

/* print
 */
void Fraction::print()
{
    std::cout << numer << '/' << denom << std::endl;
}

} // **** Koniec przestrzeni nazw CPPBook ********************************

