// Szukanie zgubionych kluczy.
#include <iostream> 
#include <stack> 
#include <string> 
#include <vector> 
 
using namespace std; 
  
// Informacja o pokoju.
struct RoomInfo {  
  string from;  
  string to; 
  bool skip; 
  
  RoomInfo() { 
    from = ""; 
    to = ""; 
    skip = false; 
  } 
 
  RoomInfo(string f, string t) {  
    from = f;  
    to = t;  
    skip = false;  
  }  
};  
 
// Znajd klucze przy uyciu przeszukiwania w gb.
class Search {  
  // Ten wektor przechowuje informacje o pokojach.
  vector<RoomInfo> rooms; 
 
  // Ten stos jest uywany przy zawracaniu.
  stack<RoomInfo> btStack;  
 

  // Zwraca warto true jeli istnieje trasa midzy
  // from i to. Zwraca false w przeciwym przypadku.
  bool match(string from, string to); 
 
  // Znajd dowolne poczenie z from.
  // Zwraca true jeli istnieje poczenie,
  // false w przeciwnym razie. 
  bool find(string from, RoomInfo &f); 
 
public:  
 
  // Dodaj pokj do bazy danych
  void addroom(string from, string to)  
  {  
    rooms.push_back(RoomInfo(from, to));  
  }  
 
  // Poka tras.
  void route();  
 
  // Okrel, czy istnieje trasa pomidzy from i to.
  void findkeys(string from, string to); 
 
  // Zwraca warto true jeli klucze zostay znalezione
  bool keysfound() { 
    return !btStack.empty(); 
  } 
};  
 
// Poka tras.
void Search::route()  
{  
  stack<RoomInfo> rev;  
  RoomInfo f;  
  
  // Odwr stos, aby pokaza tras.
  while(!btStack.empty()) { 
    f = btStack.top(); 
    rev.push(f); 
    btStack.pop(); 
  } 
  
  // Poka tras.
  while(!rev.empty()) { 
    f = rev.top(); 
    rev.pop();  
    cout << f.from << " - ";  
  }  
  
  cout << f.to << endl;  
}  
  
// Zwraca warto true jeli istnieje trasa midzy
// from i to. Zwraca false w przeciwym przypadku.
bool Search::match(string from, string to)  
{  
  for(unsigned i=0; i < rooms.size(); i++) {  
    if(rooms[i].from == from &&  
       rooms[i].to == to && !rooms[i].skip)  
    {  
      rooms[i].skip = true; // nie uywa ponownie
      return true; 
    }  
  }  
  
  return false; // nie znaleziono
}  
    
// Znajd dowolne poczenie z from.
// Zwraca true jeli istnieje poczenie,
// false w przeciwnym razie. 
bool Search::find(string from, RoomInfo &f)  
{  
  for(unsigned i=0; i < rooms.size(); i++) {  
    if(rooms[i].from == from && !rooms[i].skip) {  
      f = rooms[i]; 
      rooms[i].skip = true; // nie uywa ponownie
  
      return true;  
    }  
  }  
  
  return false;  
}  
    
// Znajd klucze.
void Search::findkeys(string from, string to)  
{  
  RoomInfo f;  
  
  // Zobacz czy znaleziono klucze.
  if(match(from, to)) { 
    btStack.push(RoomInfo(from, to));  
    return;  
  }  
  
  // Sprawd inny pokj.
  if(find(from, f)) { 
    btStack.push(RoomInfo(from, to));  
    findkeys(f.to, to);  
  }  
  else if(!btStack.empty()) {  
    // Zawr i sprbuj inn ciek.
    f = btStack.top(); 
    btStack.pop();  
    findkeys(f.from, f.to);  
  }  
} 
 
int main() {  
  Search ob; 
 
  // Dodaj pokoje do bazy danych.
  ob.addroom("drzwi wejciowe", "pokj dzienny");  
  ob.addroom("pokj dzienny", "azienka");  
  ob.addroom("azienka", "korytarz");  
  ob.addroom("korytarz", "pierwsza sypialna");  
  ob.addroom("korytarz", "druga sypialnia");  
  ob.addroom("korytarz", "gwna sypialnia");  
  ob.addroom("pokj dzieny", "kuchnia");  
  ob.addroom("kuchnia", "klucze");  
 
  // Znajd klucze.
  ob.findkeys("drzwi wejciowe", "klucze");  
  
  // Jeli klucze zostay znalezione, poka ciek.
  if(ob.keysfound())  
      ob.route();  
 
  return 0; 
} 

