// Wersja z przeszukiwaniem wszerz.
// Okrel czy istnieje trasa midzy from a to
void Search::findroute(string from, string to)  
{  
  int dist;  
  FlightInfo f;  
  
  // Ten stos jest wymagany przez przeszukiwanie wszerz.
  stack<FlightInfo> resetStck; 
  
  // Zobacz czy w miejscu przylotu
  if(match(from, to, dist)) {  
    btStack.push(FlightInfo(from, to, dist));  
    return;  
  }  
  
  // To jest pierwsza cz modyfikacji wymaganych do 
  // implementacji przeszukiwania wszerz. Sprawdza 
  // wszystkie poczenia z podanego wierzchoka.
  while(find(from, f)) {  
    resetStck.push(f);  
    if(match(f.to, to, dist)) {  
      resetStck.push(FlightInfo(f));  
      btStack.push(FlightInfo(from, f.to, f.distance));  
      btStack.push(FlightInfo(f.to, to, dist));  
      return;  
    }  
  }  
  
  // Nastpujcy kod zeruje pola skip ustawione przez
  // poprzedni ptl while. To take jest cz modyfikacji
  // wymaganych do implementacji przeszukiwania wszerz.
  while(!resetStck.empty()) { 
    resetSkip(resetStck.top()); 
    resetStck.pop(); 
  }  
  
  // Sprbuj innego poczenia
  if(find(from, f)) {  
    btStack.push(FlightInfo(from, to, f.distance));  
    findroute(f.to, to);  
  }  
  else if(!btStack.empty()) {  
    // Zawr i sprbuj innego poczenia
    f = btStack.top(); 
    btStack.pop();  
    findroute(f.from, f.to);  
  }  
}

