// WinDL: Program do cigania plikw z graficznym interfejsem uytkownika. 
 
#include <windows.h> 
#include <commctrl.h> 
#include <cstring> 
#include <cstdio> 
#include "windl.h" 
#include <process.h> 
#include "dl.h" 
 
const int URL_BUF_SIZE = 1024; 
 
LRESULT CALLBACK WindowFunc(HWND, UINT, WPARAM, LPARAM); 
BOOL CALLBACK DialogFunc(HWND, UINT, WPARAM, LPARAM); 
 
void showprogress(unsigned long total, 
                  unsigned long part); 
void resetprogress(); 
unsigned __stdcall dlstart(void * reload); 
 
char szWinName[] = "Download"; // nazwa klasy opisujcej okno aplikacji  
 
HINSTANCE hInst; // uchwyt obiektu aplikacji 
HWND hwnd;       // uchwyt gwnego okna 
HWND hProgWnd;   // uchwyt paska postpu 
 
HANDLE hThrd = 0;  // uchwyt wtku 
unsigned long Tid; // identyfikator wtku 
 
// Liczniki postpu. 
int percentdone = 0; 
int oldpercentdone = 0; 
 
// Niewielka struktura wykorzystywana do przekazywania informacji do funkcji dlstart().
struct ThrdInfo { 
  char *url;     // wskanik do acucha przechowujcego adres URL
  int reload;    // znacznik cigania caego pliku - reload
  HWND hPBStart; // uchwyt przycisku Start 
}; 
 
int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,  
                   LPSTR lpszArgs, int nWinMode) 
{ 
  MSG msg; 
  WNDCLASSEX wcl; 
  INITCOMMONCONTROLSEX cc; 
 
  // Definicja klasy okna  
  wcl.cbSize = sizeof(WNDCLASSEX);  
 
  wcl.hInstance = hThisInst;     // uchwyt do biecego egzemplarza
  wcl.lpszClassName = szWinName; // nazwa klasy okna  
  wcl.lpfnWndProc = WindowFunc;  // funkcja obsugujca okno  
  wcl.style = 0;                 // styl domylny  
 
  wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION); // dua ikona
  wcl.hIconSm = NULL; // uyj mniejszej wersji duej ikony
  wcl.hCursor = LoadCursor(NULL, IDC_ARROW);  // typ kursora
 
  wcl.lpszMenuName = NULL; // bez menu
 
  wcl.cbClsExtra = 0; // bez dodatkw
  wcl.cbWndExtra = 0;  
 
  wcl.hbrBackground = NULL; // to nie jest wykorzystywane
 
  // Zarejestruj klas okna.  
  if(!RegisterClassEx(&wcl)) return 0; 
 
  // Utwrz gwne okno, ktre nie bdzie widoczne. 
  hwnd = CreateWindow( 
    szWinName,  // nazwa klasy okna  
    "cignij Plik", // tytu 
    0,          // nie potrzeba stylu 
    0, 0, 0, 0, // nie potrzeba wymiarw    
    NULL,       // bez okna nadrzdnego  
    NULL,       // bez menu 
    hThisInst,  // uchwyt  
    NULL        // bez dodatkowych argumentw  
  ); 
 
  hInst = hThisInst; // zapisz uchwyt do biecego ezgemplarza  
 
  // Dokonaj inicjalizacji standardowych formantw. 
  // Czynno ta jest wymagana ze wzgldu na fakt uycia paska postpu. 
  cc.dwSize = sizeof(INITCOMMONCONTROLSEX); 
  cc.dwICC = ICC_PROGRESS_CLASS;  
  InitCommonControlsEx(&cc);  
 
  // Zminimalizuj okno. 
  ShowWindow(hwnd, SW_SHOWMINIMIZED); 
 
  // Utwrz okno dialogowe cignij Plik.. 
  DialogBox(hInst, "DLDB", hwnd, (DLGPROC) DialogFunc); 
 
  // Utwrz ptl zdarze.  
  while(GetMessage(&msg, NULL, 0, 0)) 
  { 
    TranslateMessage(&msg); // przekszta zdarzenia klawiaturowe 
    DispatchMessage(&msg); // zwr sterowanie do Windows 
  } 
 
  return msg.wParam; 
} 
 
// Funkcja obsugi okna. 
LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message, 
                            WPARAM wParam, LPARAM lParam) 
{ 
  switch(message) { 
    case WM_DESTROY: 
      PostQuitMessage(0); // zakocz program 
      break; 
    default: 
      return DefWindowProc(hwnd, message, wParam, lParam); 
  } 
  return 0; 
} 
 
// Funkcja obsugi okna dialogowego cignij Plik. 
BOOL CALLBACK DialogFunc(HWND hdwnd, UINT message, 
                         WPARAM wParam, LPARAM lParam) 
{ 
  // Tutaj zmienna url zostaa zainicjalizowana przykadowym adresem url
  // dla celw demonstracyjnych. 
  static char url[URL_BUF_SIZE] = 
    "http://www.osborne.com/products/0072226803/0072226803_code.zip"; 
 
  static ThrdInfo ti; 
 
  switch(message) { 
    case WM_INITDIALOG: 
      // Wstaw adres URL do pola tekstowego . 
      SetDlgItemText(hdwnd, IDD_EB1, url); 
 
      // Utwrz pasek postpu. 
      hProgWnd = CreateWindow(PROGRESS_CLASS, 
                   "", 
                   WS_CHILD | WS_VISIBLE | WS_BORDER, 
                   4, 64, 320, 12, 
                   hdwnd, NULL, hInst, NULL); 
 
      // Ustaw krok na 1. 
      SendMessage(hProgWnd, PBM_SETSTEP, 1, 0); 
 
      return 1; 
    case WM_COMMAND: 
      switch(LOWORD(wParam)) { 
        case IDCANCEL: 
          EndDialog(hdwnd, 0); 
          PostQuitMessage(0); 
 
          return 1; 
 
        case IDD_START: // rozpoczcie cigania 
          // Ustaw pozycj paska na 0. 
          SendMessage(hProgWnd, PBM_SETPOS, 0, 0); 
 
          // Pobierz adres z pola tekstowego. 
          GetDlgItemText(hdwnd, IDD_EB1, url, URL_BUF_SIZE); 
          ti.url = url; 
 
          // Pobierz stan opcji cakowitego cigania. 
          ti.reload = SendDlgItemMessage(hdwnd, IDD_CB1, 
                       BM_GETCHECK, 0, 0); 
 
          // Pobierz uchwty do przycisku Start. 
          ti.hPBStart = GetDlgItem(hdwnd, IDD_START); 
 
          // Zresetuj liczniki postpu. 
          resetprogress(); 
 
          // Rozpocznij wtek wykonujcy ciganie. 
          if(!hThrd)  
            hThrd = (HANDLE) _beginthreadex(NULL, 0, dlstart, 
                    (void *) &ti, 0, (unsigned *) &Tid);   
   
          return 1; 
      } 
  } 
 
  return 0; 
} 
 
// Poka stan cigania na pasku postpu. Zdefiniowana 
// tutaj funkcja wywoywana jest przez metod download(). 
void showprogress(unsigned long total, 
                  unsigned long part) { 
 
  percentdone = (part*100)/total; 
 
  if(percentdone > oldpercentdone) { 
    for(int i= oldpercentdone; i < percentdone; i++) { 
      // Przesu pasek postpu. 
      SendMessage(hProgWnd, PBM_STEPIT, 0, 0); 
    } 
    oldpercentdone = percentdone; 
  } 
} 
 
// Zresetuj liczniki postpu. 
void resetprogress() { 
  percentdone = 0; 
  oldpercentdone = 0; 
} 
 
// Funkcja wejciowa wtku rozpoczynajca ciganie. 
unsigned __stdcall dlstart(void * param) { 
  ThrdInfo *tip = (ThrdInfo *) param; 
 
  // Zablokuj przycisk Start. 
  EnableWindow(tip->hPBStart, 0); 
 
  try { 
    if(tip->reload == BST_CHECKED) 
      Download::download(tip->url, true, showprogress); 
    else 
      Download::download(tip->url, false, showprogress); 
  } catch(DLExc exc) { 
      MessageBox(hwnd, exc.geterr(), 
                 "Bd podczas cigania", MB_OK); 
  } 
 
  // Udostpnij przycisk Start. 
  EnableWindow(tip->hPBStart, 1); 
 
  CloseHandle(hThrd); // zamknij uchwyt wtku 
  hThrd = 0; // ustaw uchwyt wtku jako nieaktywny 
 
  return 0; 
}
