// Zawarto przetumaczona z pliku rdowego .exp.
// Prezentacja wszystkich eksperymentalnych elementw
// obsugiwanych przez translator. 
#include <iostream> 
using namespace std; 
 
// Tworzenie polimorficznej klasy bazowej.
class A { 
public: 
  virtual void f() { }; 
}; 
 
// Oraz konkretnej klasy dziedziczcej. 
class B: public A { 
public: 
  void f() {} 
}; 
 
int main() { 
  int n[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 }; 
  double dn[] = {1.1, 2.2, 3.3, 4.4 }; 
 
  cout << "Uycie ptli foreach.\n"; 
 
  /* Sowa kluczowe, takie jak foreach lub typeof 
     s ignorowane, gdy znajduj si w komentarzach
     lub acuchach znakowych objtych cudzysowami. */ 
 
  // Ptla foreach. 
  int _ia = 0;
  for(int x = n[0];
      _ia < ((sizeof n)/(sizeof n[0]));
      _ia++, x = n[_ia]) 
    cout << x << ' '; 
 
  cout << "\n\n"; 
 
  cout << "Uycie zagniedonych ptli foreach.\n"; 
 
  // Ptla foreach z blokiem polece. 
  int _ib = 0;
  for(double f = dn[0];
      _ib < ((sizeof dn)/(sizeof dn[0]));
      _ib++, f = dn[_ib]) { 
    cout << f << ' '; 
    cout << f*f << ' '; 
 
    // Zagniedona ptla foreach. 
    int _ic = 0;
    for(double f = dn[0];
        _ic < ((sizeof dn)/(sizeof dn[0]));
        _ic++, f = dn[_ic])  
      cout << f/3 << " "; 
 
    cout << endl; 
  } 
 
  cout << endl; 
 
  cout << "Prezentacja wyraenia cases.\n"; 
 
  cout << "Wyraenie cases z liczbami cakowitymi:\n"; 
 
  // Prezentacja wyraenia cases z liczbami cakowitymi
  for(int i=0; i < 12; i++)  
    switch(i) { 
      case 0: 
        cout << "case 0\n"; 
        break; 
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: 
        cout << "cases 1 to 6\n"; 
        break; 
      case 7:  
        cout << "case 7\n"; 
        break; 
      case 8:
      case 9:
      case 10: 
        cout << "cases 8 to 10\n"; 
        break; 
      default: 
        cout << "case 11\n"; 
    } 
   
  cout << "\n"; 
 
  cout << "Wyraenie cases ze znakami:\n"; 
 
  // Prezentacja wyraenia cases ze znakami
  for(char ch='a'; ch <= 'e'; ch++)  
    switch(ch) { 
      case 'a': 
        cout << "case a\n"; 
        break; 
      case 98:
      case 99:
      case 100: 
        cout << "cases b to d\n"; 
        break; 
      case 'e':  
        cout << "case e\n"; 
    } 
 
  cout << endl; 
 
  cout << "Ptla repeat-until.\n"; 
 
  // Prezentacja ptli repeat-until. 
  int k = 0; 
  do { 
    k++; 
    cout << "k: " << k << " "; 
  } while(!(k==10)); 
 
  cout << "\n\n"; 
 
  cout << "Uycie operatora typeof.\n"; 
 
  // Prezentacja operatora typeof. 
  A *aPtr; 
  B *bPtr, bObj; 
   
  // Przypisz wskanik klasy bazowej do obiektu dziedziczcego. 
  aPtr = &bObj; 
  bPtr = &bObj; 
 
  if(typeid(*aPtr) == typeid(*bPtr)) 
    cout << "aPtr wskazuje na obiekt tego samego typu co bPtr\n"; 
 
  if(typeid(*aPtr) == typeid(B)) 
   cout << "aPtr wskazuje obiekt klasy B\n"; 
 
  return 0; 
}
